/**
 * \file src/CaloLevel2.cpp
 * \author Emiliano Mocchiutti
 *
**/
#include <TObject.h>
#include <CaloLevel2.h>
ClassImp(CaloTrkVar);
ClassImp(CaloLevel2);

/**
 * CaloTrkVar constructor
**/
CaloTrkVar::CaloTrkVar() {
  trkseqno = 0;
  noint = 0;
  ncore = 0;
  qcore = 0.;
  ncyl = 0;
  qcyl = 0.;
  qtrack = 0.;
  qtrackx = 0.;
  qtracky = 0.;
  dxtrack = 0.;
  dytrack = 0.;
  qlast = 0.;
  nlast = 0;
  qpre = 0.;
  npre = 0;
  qpresh = 0.;
  npresh = 0;
  qtr = 0.;
  ntr = 0;
  planetot = 0;
  qmean = 0.;
  qlow = 0.;
  nlow = 0;
  dX0l = 0.;
  for (Int_t i = 0; i<2 ; i++){
    for ( Int_t j = 0; j<22; j++){
      tibar[j][i] = 0;		
      tbar[j][i] = 0.;    
    };
  };
}

/**
 * Copies from t to this
**/
CaloTrkVar::CaloTrkVar(const CaloTrkVar &t){
  trkseqno = t.trkseqno;
  noint = t.noint;
  ncore = t.ncore;
  qcore = t.qcore;
  ncyl = t.ncyl;
  qcyl = t.qcyl;
  qtrack = t.qtrack;
  qtrackx = t.qtrackx;
  qtracky = t.qtracky;
  dxtrack = t.dxtrack;
  dytrack = t.dytrack;
  qlast = t.qlast;
  nlast = t.nlast;
  qpre = t.qpre;
  npre = t.npre;
  qpresh = t.qpresh;
  npresh = t.npresh;
  qtr = t.qtr;
  ntr = t.ntr;  
  planetot = t.planetot;
  qmean = t.qmean;
  dX0l = t.dX0l;
  qlow = t.qlow;
  nlow = t.nlow;
  memcpy(tibar,t.tibar,sizeof(tibar));
  memcpy(tbar,t.tbar,sizeof(tbar));
}

/**
 * CaloLevel2 constructor
**/
CaloLevel2::CaloLevel2() {    
  //
  CaloTrk = new TClonesArray("CaloTrkVar",1);
  //
  nstrip = 0;
  qtot = 0.;
  impx = 0.;
  impy = 0.;
  tanx = 0.;
  tany = 0.;
  qmax = 0.;
  nx22 = 0;
  qx22 = 0.;
  elen = 0.;
  selen = 0.;
  for (Int_t i = 0; i<4 ; i++){
    qq[i] = 0.;
    perr[i] = 0;
    swerr[i] = 0;
    crc[i] = 0;
    if ( i < 2 ){
      planemax[i] = 0;
      varcfit[i] = 0.;
      npcfit[i] = 0;
      for ( Int_t j = 0; j<22; j++){
	cibar[j][i] = 0;
	cbar[j][i] = 0.;
      };
    };
  };
  good = 0;
  selftrigger = 0;
  estrip = TArrayF(0,NULL);
};

/**
 * Gives the detected energy for the given strip once loaded the event
**/
Float_t CaloLevel2::GetEstrip(Int_t view, Int_t plane, Int_t strip){
  Int_t splane = 0;
  Int_t sstrip = 0;
  //
  if ( nstrip == 0 ) return(0.);
  //
  for (Int_t i = 0; i<nstrip; i++ ){
    if ( view == 0 ){
      if ( estrip.At(i) > 0. ){
	splane = (Int_t)trunc(estrip.At(i)/1000000.);
	sstrip = (Int_t)trunc((estrip.At(i)-((Float_t)splane*1000000.))/10000.);
	if ( splane == plane && sstrip == strip ) return(estrip.At(i)-(Float_t)splane*1000000.-(Float_t)sstrip*10000.);
      };	
    } else {
      if ( estrip.At(i) < 0. ){
	splane = (Int_t)trunc(-estrip.At(i)/1000000.);
	sstrip = (Int_t)trunc((-estrip.At(i)-((Float_t)splane*1000000.))/10000.);
	if ( splane == plane && sstrip == strip ) return(-estrip.At(i)-(Float_t)splane*1000000.-(Float_t)sstrip*10000.);	
      };	
    };
  };
  return(0.);
};

/**
 * Given estrip entry returns energy and strip
**/
Float_t CaloLevel2::DecodeEstrip(Int_t entry, Int_t &view, Int_t &plane, Int_t &strip){
  if ( entry>nstrip ) return(0.);
  //
  if ( estrip.At(entry) > 0. ){
    view = 0;
    plane = (Int_t)trunc(estrip.At(entry)/1000000.);
    strip = (Int_t)trunc((estrip.At(entry)-((Float_t)plane*1000000.))/10000.);
    return(estrip.At(entry)-(Float_t)plane*1000000.-(Float_t)strip*10000.);
  };
  if ( estrip.At(entry) < 0. ){
    view = 1;
    plane = (Int_t)trunc(-estrip.At(entry)/1000000.);
    strip = (Int_t)trunc((-estrip.At(entry)-((Float_t)plane*1000000.))/10000.);
    return(-estrip.At(entry)-(Float_t)plane*1000000.-(Float_t)strip*10000.);	
  };	
  //
  printf(" WARNING: problems decoding value %f at entry %i \n",estrip.At(entry),entry);
  //
  view = -1;
  plane = -1;
  strip = -1;
  return(0.);  
}

void CaloLevel2::GetElectronEnergy(Float_t &energy, Float_t &sigma){
  if ( nstrip == 0 ) return;
  energy = qtot * 40.82 * 0.000106;
  sigma = 0.;
  if ( energy > 0. ) sigma = energy * (0.01183 + 0.121/sqrt(energy));
  return;
};

/**
 * Returns pointer to the set of track-related variables "itrk"
**/
CaloTrkVar *CaloLevel2::GetCaloTrkVar(Int_t itrk){
  //    
  if(itrk >= ntrk()){
    printf(" CaloLevel2 ERROR: track related variables set %i does not exists! \n",itrk);
    printf("                   stored track related variables = %i \n",ntrk());
    return(NULL);
  }
  TClonesArray &t = *(CaloTrk);
  CaloTrkVar *calotrack = (CaloTrkVar*)t[itrk];
  return calotrack;
}
